function [ clapdata ] = hiscale_importCLAP()

cd('E:\Google Drive\Projects\HI-SCALE SGP\Data\Peripheral Data\CLAP');
currdir = dir;

clap_time = [];

abs_blue = [];
abs_green = [];
abs_red = [];
sample_length = [];
flow_rate = [];
flags = [];

for i = 1:length(currdir)
	currfile = currdir(i).name;
	
	cdfcheck = contains(currfile,'.cdf') || contains(currfile,'.nc');
	if cdfcheck == 0
		continue
	end
	
	clap_time = [clap_time ; ARMtimeimport(currfile,19)];
	
	abs_blue = [abs_blue; ncread(currfile,'Ba_B_CLAP3W')];
	abs_green = [abs_green; ncread(currfile,'Ba_G_CLAP3W')];
	abs_red = [abs_red ; ncread(currfile,'Ba_R_CLAP3W')];
	sample_length = [sample_length ; ncread(currfile,'sample_length')];
	flow_rate = [flow_rate; ncread(currfile,'clap_flow_rate')];
	flags = [flags; ncread(currfile,'instrument_flags')];
end

clapdata.time = clap_time;
clapdata.abs_blue = abs_blue;
clapdata.abs_green = abs_green;
clapdata.abs_red = abs_red;
clapdata.sample_length = sample_length;
clapdata.flow_rate = flow_rate;
clapdata.flags = flags;


end